//-------------------------------------------------------------------------------------
// SID Monitor - Utility for Sudden Ionospheric Disturbances Monitoring Stations
// Copyright (C) 2006 - Lionel Loudet
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//-------------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using WeifenLuo.WinFormsUI;

namespace SID_monitor
{
    public partial class ViewerDockablePanel : DockContent
    {

        // Viewer... methods signature
        public delegate String GenerateGraphFileDelegate(string ChannelsDatabaseName, string GOESDatabaseName, string GraphStartTime, string GraphEndTime, string GraphTitle, bool ShowSun, bool ShowForecast, string[] ChannelStationCodes, string[] ChannelTitles, string[] ChannelLineWidths, string[] ChannelColors, string[] ChannelDev1Colors, string[] ChannelDev2Colors, string[] ChannelDev3Colors, bool[] channelsToShow, string[] GOESTitles, string[] GOESLineWidths, string[] GOESColors, bool[] GOESToShow);
        public delegate void GenerateGraphDelegate (string ChannelsDatabaseName, string GOESDatabaseName, string GraphStartTime, string GraphEndTime, string GraphTitle, bool ShowSun, bool ShowForecast, string[] ChannelStationCodes, string[] ChannelTitles, string[] ChannelLineWidths, string[] ChannelColors, string[] ChannelDev1Colors, string[] ChannelDev2Colors, string[] ChannelDev3Colors, bool[] channelsToShow, string[] GOESTitles, string[] GOESLineWidths, string[] GOESColors, bool[] GOESToShow);
        public delegate void SaveGraphFileDelegate();


        // declaration of the public methods
        public GenerateGraphFileDelegate GenerateGraphFile;
        public GenerateGraphDelegate GenerateGraph;
        public SaveGraphFileDelegate SaveGraphFile;

        public ViewerDockablePanel()
        {
            InitializeComponent();

            // definition of the public methods
            GenerateGraphFile = this.viewer.GenerateGraphFile;
            GenerateGraph = this.viewer.GenerateGraph;
            SaveGraphFile = this.viewer.SaveGraphFile;
        }

        #region Properties
        public Image Image
        {
            get
            {
                return this.viewer.Image;
            }
            set
            {
                this.viewer.Image = value;
            }
        }
        #endregion

        #region viewer Events Handling
        private void viewer_UpdateRequested(object sender, EventArgs e)
        {
            OnGraphUpdateRequested(e);
        }

        private void viewer_GraphFileChanged(object sender, PictureViewer.Viewer.GraphFileChangeEventArgs e)
        {
            OnGraphFileChanged(e);
        }
        #endregion

        #region Events

        /// <summary>
        /// GraphFileChanged Event
        /// </summary>
        public event PictureViewer.Viewer.GraphFileChangeEventHandler GraphFileChanged; // the displayed graph file has changed

        protected virtual void OnGraphFileChanged(PictureViewer.Viewer.GraphFileChangeEventArgs e)
        {
            PictureViewer.Viewer.GraphFileChangeEventHandler handler = GraphFileChanged;
            if (handler != null)
            {
                // Invokes the delegates. 
                handler(this, e);
            }
        }


        /// <summary>
        /// GraphUpdateRequested Event
        /// </summary>

        public event EventHandler GraphUpdateRequested;  // GOES download is requested

        protected virtual void OnGraphUpdateRequested(EventArgs e)
        {
            EventHandler handler = GraphUpdateRequested;
            if (handler != null)
            {
                // Invokes the delegates. 
                handler(this, e);
            }
        }


        #endregion Events


    }
}
